---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：55-Awareness Health

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **大規模クラスタでのパフォーマンス特性**：実測データなし
  2. **未割り当てシャードの集計方法**：特定属性値に紐付かないシャードの扱い

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/cluster/awarenesshealth/ClusterAwarenessHealth.java`
- E-02: `server/src/main/java/org/opensearch/cluster/awarenesshealth/ClusterAwarenessAttributesHealth.java`
- E-03: `server/src/main/java/org/opensearch/cluster/awarenesshealth/ClusterAwarenessAttributeValueHealth.java`
- E-04: `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthRequest.java`
- E-05: `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthResponse.java`
- E-06: `server/src/main/java/org/opensearch/action/admin/cluster/health/TransportClusterHealthAction.java`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ClusterAwarenessHealthがトップレベルクラス | E-01 | ○ |
| C-02 | ClusterAwarenessAttributesHealthが属性ごとのヘルス情報を保持 | E-02 | ○ |
| C-03 | ClusterAwarenessAttributeValueHealthが属性値ごとのヘルス詳細を保持 | E-03 | ○ |
| C-04 | ClusterHealthRequest.Level.AWARENESS_ATTRIBUTESが追加されている | E-04 | ○ |
| C-05 | level=awareness_attributesでアウェアネスヘルスを取得 | E-04 | ○ |
| C-06 | awareness_attributeパラメータが必須 | E-04 | ○ |
| C-07 | active_shards, initializing_shards, relocating_shards, unassigned_shardsが含まれる | E-03 | ○ |
| C-08 | data_nodesが属性値ごとのデータノード数を示す | E-03 | ○ |
| C-09 | weightがWeightedRoutingMetadataから取得される | E-03 | ○ |
| C-10 | TransportClusterHealthActionで処理される | E-06 | ○ |
| C-11 | データノードのみを対象とする | E-02 | ○ |
| C-12 | 機能一覧でNo.55がAwareness Healthとして定義 | E-07 | ○ |
| C-13 | cluster:monitor/healthアクション権限が必要 | E-06 | ○ |
| C-14 | メモリ内操作のため軽量 | E-01, E-02, E-03 | ○ |
| C-15 | 大規模クラスタでもミリ秒オーダーで応答 | **根拠なし** | △ |
| C-16 | 未割り当てシャードは特定属性値に紐付かない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 大規模クラスタでのパフォーマンス測定データは未取得
- 未割り当てシャードの集計ロジックの詳細は未精査
  - 候補：`ClusterAwarenessAttributesHealth.java`の集計部分

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- データ構造はソースコードから確認済み
- 0: 低リスク -- REST APIパラメータはClusterHealthRequestから確認済み
- 1: 中リスク -- パフォーマンス特性は実測が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ClusterHealthRequest.Level.AWARENESS_ATTRIBUTESの定義を確認
- [ ] awareness_attributeパラメータの必須チェックロジックを確認
- [ ] 未割り当てシャードの集計方法を確認
- [ ] 重み情報取得のWeightedRoutingMetadata連携を確認
